<?php
/**
 * Sets all of our theme defaults.
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'manisha_get_defaults' ) ) {
	// Set default options
	function manisha_get_defaults() {
		$manisha_defaults = array(
			'hide_title' => '',
			'hide_tagline' => true,
			'custom_logo' => '',
			'retina_logo' => '',
			'logo_width' => '8',
			'mobile_logo_width' => '12',
			'desktop_logo_width_unit' => 'vw',
			'mobile_logo_width_unit' => 'vw',
			'header_layout_setting' => 'fluid-header',
			'header_inner_width' => 'full-width',
			'header_alignment_setting' => 'left',
			'nav_alignment_setting' => 'left',
			'nav_inner_width' => 'full-width',
			'nav_position_setting' => 'nav-float-right',
			'nav_border' => 'enable',
			'nav_effect' => 'stylea',
			'navigation_items_spacing' => '1',
			'desktop_navigation_items_spacing_unit' => 'vw',
			'navigation_items_width' => '0.5',
			'desktop_navigation_items_width_unit' => 'vw',
			'navigation_items_height' => '1.8',
			'desktop_navigation_items_height_unit' => 'em',
			'subnavigation_width' => '200',
			'desktop_subnavigation_width_unit' => 'px',
			'nav_dropdown_type' => 'hover',
			'nav_dropdown_direction' => 'right',
			'nav_search' => 'disable',
			'wpkoi_cart' => 'enable',
			'fixed_side_content' => '',
			'socials_facebook_url' => '',
			'socials_twitter_url' => '',
			'socials_instagram_url' => '',
			'socials_youtube_url' => '',
			'socials_tiktok_url' => '',
			'socials_twitch_url' => '',
			'socials_tumblr_url' => '',
			'socials_pinterest_url' => '',
			'socials_linkedin_url' => '',
			'socials_custom_icon_1' => '',
			'socials_custom_icon_2' => '',
			'socials_custom_icon_3' => '',
			'socials_custom_icon_url_1' => '',
			'socials_custom_icon_url_2' => '',
			'socials_custom_icon_url_3' => '',
			'socials_mail_url' => '',
			'button_border_style' => 'solid',
			'button_border' => '2',
			'button_radius' => '10',
			'button_rotate' => '0',
			'back_to_top' => 'enable',
			'content_link_dec' => 'enable',
			'top_bar_mobile' => 'desktop',
			'sticky_header' => 'enable',
			'disable_site_info' => 'enable',
			'smooth_scroll' => 'enable',
			'stylish_scrollbar' => 'enable',
			'enable_noise' => 'disable',
			'noise_image' => '',
			'image_cursor' => 'enable',
			'def_cursor_image' => get_template_directory_uri() . '/img/image-cursor.png',
			'pointer_cursor_image' => get_template_directory_uri() . '/img/image-pointer.png',
			'text_color' => '#000000',
			'link_color' => '#000000',
			'link_color_hover' => '#333333',
			'side_inside_color' => '',
			'header_background_color' => '',
			'header_text_color' => '#000000',
			'header_link_color' => '#000000',
			'header_link_hover_color' => '#333333',
			'site_title_color' => '#000000',
			'site_title_bg_color' => '#FCE205',
			'sticky_header_background_color' => '#f4f0cb',
			'navigation_background_color' => '#f4f0cb',
			'navigation_text_color' => '#000000',
			'navigation_background_hover_color' => '#FF99FF',
			'navigation_text_hover_color' => '#000000',
			'navigation_background_current_color' => '#FF99FF',
			'navigation_text_current_color' => '#000000',
			'navigation_border_color' => '#000000',
			'subnavigation_background_color' => '#000000',
			'subnavigation_text_color' => '#ffffff',
			'subnavigation_background_hover_color' => '#333333',
			'subnavigation_text_hover_color' => '#ffffff',
			'subnavigation_background_current_color' => '#333333',
			'subnavigation_text_current_color' => '#ffffff',
			'form_button_background_color' => '#ffffff',
			'form_button_text_color' => '#000000',
			'form_button_background_color_hover' => '#000000',
			'form_button_text_color_hover' => '#ffffff',
			'form_button_border_color' => '#000000',
			'form_button_border_color_hover' => '#000000',
			'fixed_side_content_background_color' => '#000000',
			'fixed_side_content_text_color' => '#ffffff',
			'fixed_side_content_link_color' => '#ffffff',
			'fixed_side_content_link_hover_color' => '#eeeeee',
			'back_to_top_background_color' => '#000000',
			'back_to_top_background_color_hover' => '#333333',
			'back_to_top_text_color' => '#ffffff',
			'back_to_top_text_color_hover' => '#ffffff',
			'form_background_color' => '#ffffff',
			'form_text_color' => '#000000',
			'form_border_color' => '#000000',
			'form_background_color_focus' => '#000000',
			'form_text_color_focus' => '#ffffff',
			'form_border_color_focus' => '#000000',
			'footer_background_color' => '#000000',
			'footer_text_color' => '#ffffff',
			'footer_link_color' => '#ffffff',
			'footer_link_hover_color' => '#eeeeee',
			'scrollbar_track_color' => '#000000',
			'scrollbar_thumb_color' => '#ffffff',
			'scrollbar_thumb_hover_color' => '#eeeeee',
			'wc_sale_sticker_background' => '#000000',
			'wc_sale_sticker_text' => '#ffffff',
			'wc_price_color' => '#000000',
			'wc_product_tab' => '#ffffff',
			'wc_product_tab_highlight' => '#ffffff',
			'enable_content_width' => 'disable',
			'container_width' => '1170',
			'header_top' => '0.5',
			'header_right' => '2',
			'header_bottom' => '0.5',
			'header_left' => '2',
			'mobile_header_top' => '1',
			'mobile_header_right' => '2',
			'mobile_header_bottom' => '1',
			'mobile_header_left' => '2',
			'site_title_top' => '0',
			'site_title_right' => '1',
			'site_title_bottom' => '0',
			'site_title_left' => '1',
			'mobile_site_title_top' => '0',
			'mobile_site_title_right' => '1',
			'mobile_site_title_bottom' => '0',
			'mobile_site_title_left' => '1',
			'content_top' => '4',
			'content_right' => '2',
			'content_bottom' => '4',
			'content_left' => '2',
			'mobile_content_top' => '4',
			'mobile_content_right' => '2',
			'mobile_content_bottom' => '4',
			'mobile_content_left' => '2',
			'fixed_side_margin_top' => '250',
			'fixed_side_margin_right'=> '0',
			'fixed_side_margin_bottom' => '0',
			'fixed_side_margin_left' => '0',
			'fixed_side_top' => '9',
			'fixed_side_right' => '7',
			'fixed_side_bottom' => '9',
			'fixed_side_left' => '5',
			'fixed_side_display_mobile' => false,
			'button_top' => '10',
			'button_right' => '20',
			'button_bottom' => '10',
			'button_left' => '20',
			'side_top' => '0',
			'side_right' => '0',
			'side_bottom' => '0',
			'side_left' => '0',
			'mobile_side_top' => '0',
			'mobile_side_right' => '0',
			'mobile_side_bottom' => '0',
			'mobile_side_left' => '0',
			'side_padding_radius' => '0',
			'font_body' => 'inherit',
			'font_body_category' => '',
			'font_body_variants' => '',
			'body_font_weight' => '500',
			'body_font_transform' => 'none',
			'body_font_size' => '22',
			'mobile_body_font_size' => '22',
			'desktop_body_font_size_unit' => 'px',
			'mobile_body_font_size_unit' => 'px',
			'body_line_height' => '1.5', // no unit
			'font_site_title' => 'inherit',
			'font_site_title_category' => '',
			'font_site_title_variants' => '',
			'site_title_font_weight' => '900',
			'site_title_font_transform' => 'uppercase',
			'site_title_font_size' => '2.5',
			'mobile_site_title_font_size' => '5',
			'desktop_site_title_font_size_unit' => 'vw',
			'mobile_site_title_font_size_unit' => 'vw',
			'font_navigation' => 'inherit',
			'font_navigation_category' => '',
			'font_navigation_variants' => '',
			'navigation_font_weight' => '700',
			'navigation_font_transform' => 'uppercase',
			'navigation_font_size' => '1.3',
			'tablet_navigation_font_size' => '1.3',
			'mobile_navigation_font_size' => '14',
			'desktop_navigation_font_size_unit' => 'vw',
			'tablet_navigation_font_size_unit' => 'vw',
			'mobile_navigation_font_size_unit' => 'px',
			'font_buttons' => 'inherit',
			'font_buttons_category' => '',
			'font_buttons_variants' => '',
			'buttons_font_weight' => '700',
			'buttons_font_transform' => 'uppercase',
			'buttons_font_size' => '19',
			'mobile_buttons_font_size' => '19',
			'desktop_buttons_font_size_unit' => 'px',
			'mobile_buttons_font_size_unit' => 'px',
			'font_heading_1' => 'inherit',
			'font_heading_1_category' => '',
			'font_heading_1_variants' => '',
			'heading_1_weight' => '700',
			'heading_1_transform' => 'none',
			'heading_1_font_size' => '60',
			'mobile_heading_1_font_size' => '30',
			'desktop_heading_1_font_size_unit' => 'px',
			'mobile_heading_1_font_size_unit' => 'px',
			'heading_1_line_height' => '1.2', // em
			'font_heading_2' => 'inherit',
			'font_heading_2_category' => '',
			'font_heading_2_variants' => '',
			'heading_2_weight' => '700',
			'heading_2_transform' => 'none',
			'heading_2_font_size' => '32',
			'mobile_heading_2_font_size' => '25',
			'desktop_heading_2_font_size_unit' => 'px',
			'mobile_heading_2_font_size_unit' => 'px',
			'heading_2_line_height' => '1.2', // em
			'font_heading_3' => 'inherit',
			'font_heading_3_category' => '',
			'font_heading_3_variants' => '',
			'heading_3_weight' => '700',
			'heading_3_transform' => 'none',
			'heading_3_font_size' => '25',
			'mobile_heading_3_font_size' => '25',
			'desktop_heading_3_font_size_unit' => 'px',
			'mobile_heading_3_font_size_unit' => 'px',
			'heading_3_line_height' => '1.2', // em
			'font_heading_4' => 'inherit',
			'font_heading_4_category' => '',
			'font_heading_4_variants' => '',
			'heading_4_weight' => '700',
			'heading_4_transform' => 'none',
			'heading_4_font_size' => '20',
			'mobile_heading_4_font_size' => '20',
			'desktop_heading_4_font_size_unit' => 'px',
			'mobile_heading_4_font_size_unit' => 'px',
			'heading_4_line_height' => '1', // em
			'font_heading_5' => 'inherit',
			'font_heading_5_category' => '',
			'font_heading_5_variants' => '',
			'heading_5_weight' => 'normal',
			'heading_5_transform' => 'none',
			'heading_5_font_size' => '20',
			'mobile_heading_5_font_size' => '20',
			'desktop_heading_5_font_size_unit' => 'px',
			'mobile_heading_5_font_size_unit' => 'px',
			'heading_5_line_height' => '1', // em
			'font_heading_6' => 'inherit',
			'font_heading_6_category' => '',
			'font_heading_6_variants' => '',
			'heading_6_weight' => 'normal',
			'heading_6_transform' => 'none',
			'heading_6_font_size' => '20',
			'mobile_heading_6_font_size' => '20',
			'desktop_heading_6_font_size_unit' => 'px',
			'mobile_heading_6_font_size_unit' => 'px',
			'heading_6_line_height' => '1', // em
			'font_footer' => 'inherit',
			'font_footer_category' => '',
			'font_footer_variants' => '',
			'footer_weight' => '500',
			'footer_transform' => 'none',
			'footer_font_size' => '18',
			'mobile_footer_font_size' => '18',
			'desktop_footer_font_size_unit' => 'px',
			'mobile_footer_font_size_unit' => 'px',
			'font_fixed_side' => 'inherit',
			'font_fixed_side_category' => '',
			'font_fixed_side_variants' => '',
			'fixed_side_font_weight' => '600',
			'fixed_side_font_transform' => 'uppercase',
			'fixed_side_font_size' => '1.4',
			'mobile_fixed_side_font_size' => '22',
			'desktop_fixed_side_font_size_unit' => 'vw',
			'mobile_fixed_side_font_size_unit' => 'px',
			'form_padding_top' => '0.8rem',
			'form_padding_right' => '1rem',
			'form_padding_bottom' => '0.8rem',
			'form_padding_left' => '1rem',
			'form_border_radius' => '0px',
			'form_border_width' => '3px',
			'form_border_style' => 'solid',
			'form_checkbox_size' => '30px',
			'form_checkbox_innersize' => '18px',
			'form_checkbox_padding' => '4px',
			'form_checkbox_bordersize' => '2px',
			'nav_border_width' => '2px',
			'scrollbar_width' => '12px',
			'scrollbar_radius' => '0px',
		);

		return $manisha_defaults;
	}
}

if ( ! function_exists( 'manisha_get_default_color_palettes' ) ) {
	// Set up our colors for the color picker palettes and filter them so you can change them.
	function manisha_get_default_color_palettes() {
		$manisha_palettes = array(
			'#000000',
			'#FF99FF',
			'#FCE205',
			'#2FF55B',
			'#eeeeee',
			'#ffffff'
		);

		return $manisha_palettes;
	}
}

if ( ! function_exists( 'manisha_get_default_fonts' ) ) {
	// Set up our default fonts
	function manisha_get_default_fonts() {
		$manisha_fonts = array(
			'inherit',
			'Poppins'
		);

		return $manisha_fonts;
	}
}

if ( ! function_exists( 'manisha_get_inherit_fonts' ) ) {
	// Set up our default fonts
	function manisha_get_inherit_fonts() {
		$manisha_fonts = array(
			'bodyfont' 		  => 'Poppins',
			'font_site_title' => 'Poppins',
			'font_navigation' => 'Poppins',
			'font_buttons' 	  => 'Poppins',
			'font_heading_1'  => 'Poppins',
			'font_heading_2'  => 'Poppins',
			'font_heading_3'  => 'Poppins',
			'font_heading_4'  => 'Poppins',
			'font_heading_5'  => 'Poppins',
			'font_heading_6'  => 'Poppins',
			'font_footer' 	  => 'Poppins',
			'font_fixed_side' => 'Poppins'
		);

		return $manisha_fonts;
	}
}
