import React  from 'react';

const Settings = () => {

  const loginCodeSnippet = `[ticket_spot='REPLACE_WITH_WIDGET_ID']`;

  return (
    <div>
      <h1>Ticket Spot</h1>
      <h2>Get Started in 3 Easy Steps</h2>
      <ol>
        <li>Create your free <b><a href='https://ticketspotapp.com/manage' target='_blank'>Ticket Spot</a></b> account (takes 30 seconds)</li>
        <li>Add your WordPress site by entering your site name and URL</li>
        <li>Create an event widget and copy the generated shortcode</li>
      </ol>

      <p class="main">
      <div class="notice notice-info"><p>Once your account is set up, manage everything from the Ticket Spot dashboard: create events, design branded tickets, set up email automation, track analytics, and customize your event calendar—all from one powerful platform.</p></div>

				</p>
<div>
      <h2>Add Shortcode to Your Site</h2>
      <p>
      <label for="custom_installation">
        <p class="description" id="tagline-description">Paste this shortcode into any page, post, or widget area where you want your events to appear. Replace <code>REPLACE_WITH_WIDGET_ID</code> with the widget ID from your Ticket Spot dashboard.</p>
        <input type="text" name="custom_installation" id="custom_installation" value={loginCodeSnippet} disabled="disabled" class="regular-text" />

        </label>
      </p>
    </div>
    </div>
  );
}

export default Settings;