window.addEventListener("DOMContentLoaded", () => {
  document.querySelectorAll(".elementor-button").forEach(button => {
    if (button.classList.contains("animated-button-ready")) return;

    const textSpan = button.querySelector(".elementor-button-text");
    if (!textSpan) return;

    const text = textSpan.textContent.trim();
    if (!text) return;

    textSpan.innerHTML = `
      <span class="animated-text">
        <span class="front">${text}</span>
        <span class="back">${text}</span>
      </span>
    `;

    button.classList.add("animated-button-ready");
  });
});
