<?php

/*
Plugin Name: Simple Role Based Pricing
Version: 1.1.7
Description: A lightweight WooCommerce plugin to set custom prices or discounts for products based on user roles.
Author: tlloancy
Requires at least: 5.0
Tested up to: 6.8
Requires PHP: 7.4
License: GPLv2 or later
License URI: http://www.gnu.org/licenses/gpl-2.0.html
Text Domain: simple-role-based-pricing
Domain Path: /languages
*/

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!extension_loaded('mbstring')) {
    add_action('admin_notices', function() {
        echo '<div class="error"><p><strong>Simple Role Based Pricing:</strong> L\'extension PHP mbstring est requise pour fonctionner correctement. Veuillez l\'activer sur votre serveur.</p></div>';
    });
    return;
}

require_once plugin_dir_path(__FILE__) . 'includes/core-functions.php';
simproba_debug_log('Plugin Simple Role Based Pricing chargé.');

if (!in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) {
    simproba_debug_log('WooCommerce non actif, plugin désactivé.');
    return;
}

require_once plugin_dir_path(__FILE__) . 'includes/classes/RolePricingSettings.php';
require_once plugin_dir_path(__FILE__) . 'includes/admin/admin-settings.php';
require_once plugin_dir_path(__FILE__) . 'includes/admin/product-fields.php';
require_once plugin_dir_path(__FILE__) . 'includes/admin/bulk-actions.php';
require_once plugin_dir_path(__FILE__) . 'includes/admin/quick-edit.php';
require_once plugin_dir_path(__FILE__) . 'includes/frontend/display.php';
require_once plugin_dir_path(__FILE__) . 'includes/frontend/enqueue-scripts.php';
require_once plugin_dir_path(__FILE__) . 'includes/utils/helpers.php';
require_once plugin_dir_path(__FILE__) . 'includes/api/ajax-handlers.php';
require_once plugin_dir_path(__FILE__) . 'includes/class-simproba-pricing.php';

simproba_debug_log('Tous les fichiers inclus chargés.');

$role_pricing_settings = Simproba_Role_Pricing_Settings::get_instance();
simproba_debug_log('Instance Simproba_Role_Pricing_Settings créée.');

register_activation_hook(__FILE__, 'simproba_activate');
function simproba_activate() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'simproba_settings';
    $charset_collate = $wpdb->get_charset_collate();
    $sql = "CREATE TABLE $table_name ( id INT(11) UNSIGNED AUTO_INCREMENT, role VARCHAR(50) NOT NULL, post_type VARCHAR(20) NOT NULL DEFAULT 'product', discount_type ENUM('fixed', 'percentage', 'fixed_price') NOT NULL, discount_value DECIMAL(10,2) NOT NULL, categories TEXT DEFAULT NULL, PRIMARY KEY (id), UNIQUE KEY unique_role_post_type (role, post_type) ) $charset_collate;";
    require_once ABSPATH . 'wp-admin/includes/upgrade.php';
    dbDelta($sql);
    add_option('simproba_version', '1.0.0');
    simproba_debug_log('Plugin activé, table créée.');
}

add_filter('woocommerce_show_admin_notice', function($show, $notice_type) {
    if ($notice_type === 'update') {
        simproba_debug_log('Notification de mise à jour WooCommerce désactivée.');
        return false;
    }
    return $show;
}, 10, 2);

add_filter('woocommerce_cart_needs_payment', function($needs_payment, $cart) {
    if ($cart->get_total('edit') == 0) {
        simproba_debug_log('Bypassing payment for zero-total order');
        return false;
    }
    return $needs_payment;
}, 10, 2);

add_filter('woocommerce_order_needs_payment', function($needs_payment, $order, $valid_order_statuses) {
    if ($order->get_total() == 0) {
        simproba_debug_log('Allowing zero-total order ID: %d', $order->get_id());
        return false;
    }
    return $needs_payment;
}, 10, 3);

// Hook logger disabled to reduce clutter
/*
static $hooks = [];
add_action('all', function ($hook) use (&$hooks) {
    $hooks[] = $hook;
    simproba_debug_log('Hook exécuté: %s', $hook);
    error_log('Simproba Hook exécuté: ' . $hook);
});
add_action('wp_footer', function () use (&$hooks) {
    if (is_cart() || is_checkout()) {
        echo '<pre>Hooks exécutés sur panier/checkout: ' . print_r(array_unique($hooks), true) . '</pre>';
    }
}, 9999);
*/
