console.log('Simple Role Based Pricing: admin.js chargé');
 document.addEventListener('DOMContentLoaded', function() {
     console.log('Simple Role Based Pricing: DOM chargé');
     const form = document.getElementById('mainform');
     const saveButton = form ? form.querySelector('.woocommerce-save-button') : null;
     const roleSelector = document.getElementById('simproba_role_selector');
     const applyToSelector = document.getElementById('simproba_apply_to');
     const categorySelectorContainer = document.getElementById('simproba_category_selector_container');
     const fieldsContainer = document.getElementById('simproba_role_fields_container');
     console.log('Éléments DOM :', {
         form: !!form,
         saveButton: !!saveButton,
         roleSelector: !!roleSelector,
         applyToSelector: !!applyToSelector,
         categorySelectorContainer: !!categorySelectorContainer,
         fieldsContainer: !!fieldsContainer
     });
     if (!form || !saveButton || !roleSelector || !applyToSelector || !fieldsContainer) {
         console.error('Simple Role Based Pricing: Éléments critiques manquants');
         return;
     }
     const availableCategories = document.getElementById('available-categories')?.querySelector('ul');
     const selectedCategories = document.getElementById('selected-categories')?.querySelector('ul');
     if (!availableCategories || !selectedCategories) {
         console.warn('Simple Role Based Pricing: Pools de catégories manquants');
     }
     function renderRoleFields(role) {
         console.log('renderRoleFields appelée pour', role);
         const enableInput = document.querySelector(`input[name="simproba_enable_${role}"]`);
         const discountTypeInput = document.querySelector(`input[name="simproba_discount_type_${role}"]`);
         const discountValueInput = document.querySelector(`input[name="simproba_discount_value_${role}"]`);
         const applyToInput = document.querySelector(`input[name="simproba_apply_to_${role}"]`);
         const categoriesInput = document.querySelector(`input[name="simproba_categories_${role}"]`);
         console.log('Valeurs lues des champs cachés pour', role, ':', {
             enable: enableInput?.value,
             discount_type: discountTypeInput?.value,
             discount_value: discountValueInput?.value,
             apply_to: applyToInput?.value,
             categories: categoriesInput?.value
         });
         const settings = {
             enable: enableInput && enableInput.value ? enableInput.value : 'no',
             discount_type: discountTypeInput && discountTypeInput.value ? discountTypeInput.value : 'percentage',
             discount_value: discountValueInput && discountValueInput.value ? parseFloat(discountValueInput.value) || 0 : 0,
             apply_to: applyToInput && applyToInput.value ? applyToInput.value : 'all',
             categories: categoriesInput && categoriesInput.value ? JSON.parse(categoriesInput.value || '[]') : []
         };
         console.log('Settings chargés pour', role, ':', settings);
         fieldsContainer.innerHTML = `
             <div class="simproba-role-field">
                 <label>
                     <span class="title">${role.charAt(0).toUpperCase() + role.slice(1)} Enable</span>
                     <div class="toggle-switch">
                         <input type="checkbox" id="simproba_enable_${role}" ${settings.enable === 'yes' ? 'checked' : ''}>
                         <span class="slider"></span>
                     </div>
                 </label>
             </div>
             <div class="simproba-role-field">
                 <label>
                     <span class="title">${role.charAt(0).toUpperCase() + role.slice(1)} Discount Type</span>
                     <select id="simproba_discount_type_${role}">
                         <option value="fixed" ${settings.discount_type === 'fixed' ? 'selected' : ''}>Fixed Amount</option>
                         <option value="percentage" ${settings.discount_type === 'percentage' ? 'selected' : ''}>Percentage</option>
                         <option value="fixed_price" ${settings.discount_type === 'fixed_price' ? 'selected' : ''}>Fixed Price</option>
                     </select>
                 </label>
             </div>
             <div class="simproba-role-field">
                 <label>
                     <span class="title">${role.charAt(0).toUpperCase() + role.slice(1)} Discount Value</span>
                     <input type="number" id="simproba_discount_value_${role}" value="${settings.discount_value}" step="0.01" min="0">
                 </label>
             </div>
         `;
         if (availableCategories && selectedCategories) {
             console.log('Catégories disponibles :', Array.from(availableCategories.querySelectorAll('li')).map(li => li.dataset.category));
             categorySelectorContainer.style.display = settings.apply_to === 'categories' ? 'flex' : 'none';
             selectedCategories.innerHTML = '';
             settings.categories.forEach(categoryId => {
                 const li = document.createElement('li');
                 li.dataset.category = categoryId;
                 li.textContent = availableCategories.querySelector(`li[data-category="${categoryId}"]`)?.textContent || 'Unknown';
                 selectedCategories.appendChild(li);
             });
         }
         const enableCheckbox = document.getElementById(`simproba_enable_${role}`);
         const discountTypeSelect = document.getElementById(`simproba_discount_type_${role}`);
         const discountValueField = document.getElementById(`simproba_discount_value_${role}`);
         if (enableCheckbox && discountTypeSelect && discountValueField) {
             enableCheckbox.addEventListener('change', () => updateSettings(role));
             discountTypeSelect.addEventListener('change', () => updateSettings(role));
             discountValueField.addEventListener('input', () => updateSettings(role));
             updateSettings(role);
         } else {
             console.error('Éléments de champ manquants pour le rôle :', role);
         }
     }
     function updateSettings(role) {
         console.log('updateSettings appelée pour', role);
         const enableCheckbox = document.getElementById(`simproba_enable_${role}`);
         const discountTypeSelect = document.getElementById(`simproba_discount_type_${role}`);
         const discountValueField = document.getElementById(`simproba_discount_value_${role}`);
         if (!enableCheckbox || !discountTypeSelect || !discountValueField) {
             console.error('Éléments de champ manquants pour le rôle :', role);
             return;
         }
         let enableInput = document.querySelector(`input[name="simproba_enable_${role}"]`);
         let discountTypeInput = document.querySelector(`input[name="simproba_discount_type_${role}"]`);
         let discountValueInput = document.querySelector(`input[name="simproba_discount_value_${role}"]`);
         let applyToInput = document.querySelector(`input[name="simproba_apply_to_${role}"]`);
         let categoriesInput = document.querySelector(`input[name="simproba_categories_${role}"]`);
         if (!enableInput) {
             enableInput = document.createElement('input');
             enableInput.type = 'hidden';
             enableInput.name = `simproba_enable_${role}`;
             form.appendChild(enableInput);
         }
         if (!discountTypeInput) {
             discountTypeInput = document.createElement('input');
             discountTypeInput.type = 'hidden';
             discountTypeInput.name = `simproba_discount_type_${role}`;
             form.appendChild(discountTypeInput);
         }
         if (!discountValueInput) {
             discountValueInput = document.createElement('input');
             discountValueInput.type = 'hidden';
             discountValueInput.name = `simproba_discount_value_${role}`;
             form.appendChild(discountValueInput);
         }
         if (!applyToInput) {
             applyToInput = document.createElement('input');
             applyToInput.type = 'hidden';
             applyToInput.name = `simproba_apply_to_${role}`;
             form.appendChild(applyToInput);
         }
         if (!categoriesInput) {
             categoriesInput = document.createElement('input');
             categoriesInput.type = 'hidden';
             categoriesInput.name = `simproba_categories_${role}`;
             form.appendChild(categoriesInput);
         }
         enableInput.value = enableCheckbox.checked ? 'yes' : 'no';
         discountTypeInput.value = discountTypeSelect.value;
         discountValueInput.value = parseFloat(discountValueField.value) || 0;
         applyToInput.value = applyToSelector.value;
         categoriesInput.value = availableCategories && selectedCategories
             ? JSON.stringify(Array.from(selectedCategories.querySelectorAll('li')).map(li => parseInt(li.dataset.category)))
             : '[]';
         console.log('Mise à jour des champs cachés pour', role, ':', {
             enable: enableInput.value,
             discount_type: discountTypeInput.value,
             discount_value: discountValueInput.value,
             apply_to: applyToInput.value,
             categories: categoriesInput.value
         });
         saveButton.removeAttribute('disabled');
         if (categorySelectorContainer) {
             categorySelectorContainer.style.display = applyToSelector.value === 'categories' ? 'flex' : 'none';
         }
     }
     applyToSelector.addEventListener('change', function() {
         const role = roleSelector.value;
         if (categorySelectorContainer) {
             categorySelectorContainer.style.display = this.value === 'categories' ? 'flex' : 'none';
         }
         if (this.value === 'categories' && !window.SimpleRoleBasedPricingPro) {
             const notice = document.createElement('div');
             notice.id = 'simproba-pro-notice';
             notice.style.background = '#0073aa';
             notice.style.color = '#fff';
             notice.style.padding = '10px';
             notice.style.marginBottom = '10px';
             notice.style.borderRadius = '4px';
             notice.innerHTML = 'Category-based discounts require the Pro version. <a href="https://deter-mi.net/pro" style="color: #fff; text-decoration: underline;" target="_blank">Upgrade now</a>.';
             applyToSelector.parentNode.insertBefore(notice, applyToSelector);
             setTimeout(() => notice.remove(), 5000);
             this.value = 'all';
             categorySelectorContainer.style.display = 'none';
         }
         updateSettings(role);
     });
     roleSelector.addEventListener('change', function() {
         renderRoleFields(this.value);
     });
     function moveCategories(direction) {
         const role = roleSelector.value;
         if (!availableCategories || !selectedCategories) {
             console.warn('Pools de catégories absents');
             return;
         }
         const fromList = direction === 'right' ? availableCategories : selectedCategories;
         const toList = direction === 'right' ? selectedCategories : availableCategories;
         Array.from(fromList.querySelectorAll('li.selected')).forEach(field => {
             field.classList.remove('selected');
             const fieldValue = field.dataset.category;
             const alreadyExists = Array.from(toList.querySelectorAll('li')).some(existingField => existingField.dataset.category === fieldValue);
             if (!alreadyExists || direction === 'left') {
                 const newField = field.cloneNode(true);
                 toList.appendChild(newField);
                 if (direction === 'left') {
                     field.remove();
                 }
                 updateSettings(role);
             }
         });
     }
     if (availableCategories && selectedCategories) {
         document.querySelectorAll('.arrow-btn').forEach(button => {
             button.addEventListener('click', function(event) {
                 event.preventDefault();
                 const direction = this.dataset.direction;
                 moveCategories(direction);
             });
         });
         availableCategories.addEventListener('click', (e) => {
             if (e.target.tagName === 'LI') {
                 e.target.classList.toggle('selected');
             }
         });
         selectedCategories.addEventListener('click', (e) => {
             if (e.target.tagName === 'LI') {
                 e.target.classList.toggle('selected');
             }
         });
     }
     if (roleSelector.value) {
         renderRoleFields(roleSelector.value);
     }
     if (categorySelectorContainer) {
         categorySelectorContainer.style.display = applyToSelector.value === 'categories' ? 'flex' : 'none';
     }
     form.addEventListener('change', function(event) {
         const role = roleSelector.value;
         console.log('Simple Role Based Pricing: Changement détecté', event.target);
         updateSettings(role);
     });
     form.addEventListener('submit', function(event) {
         const role = roleSelector.value;
         console.log('Soumission du formulaire POST pour', role);
         updateSettings(role);
         saveButton.removeAttribute('disabled');
     });
 });
