<?php
defined('ABSPATH') or die('No direct access!');

add_action('admin_enqueue_scripts', 'simproba_enqueue_scripts');
function simproba_enqueue_scripts($hook) {
    if ($hook === 'woocommerce_page_wc-settings' && isset($_GET['tab']) && $_GET['tab'] === 'role_pricing') {
        wp_enqueue_script(
            'simproba-admin',
            plugins_url('js/admin.js', dirname(__DIR__)),
            ['jquery'],
            '1.0.2',
            true
        );
		wp_enqueue_style(
            'simproba-admin',
            plugins_url('css/admin.css', dirname(__DIR__)),
            [],
            '1.0.0'
        );
        simproba_debug_log("Script admin.js chargé sur la page des paramètres WooCommerce (hook: $hook)");
    }

    if ($hook === 'edit.php' || $hook === 'post.php') {
        wp_enqueue_script(
            'simproba-user',
            plugins_url('js/user.js', dirname(__DIR__)),
            ['jquery'],
            '1.0.0',
            true
        );
        wp_localize_script('simproba-user', 'simproba_nonce', wp_create_nonce('simproba_ajax_nonce'));
        wp_enqueue_style(
            'simproba-user',
            plugins_url('css/user.css', dirname(__DIR__)),
            [],
            '1.0.0'
        );
        simproba_debug_log("Scripts et styles user.js/user.css chargés (hook: $hook)");
    }
}
