<?php

defined('ABSPATH') or die('No direct access!');

simproba_debug_log('Chargement de includes/frontend/display.php');

add_filter('woocommerce_get_price_html', 'simproba_custom_price_html', 100, 2);

function simproba_custom_price_html($price_html, $product) {
    simproba_debug_log('Vérification de la remise HTML pour le produit ' . $product->get_id());
    if (!is_user_logged_in()) {
        simproba_debug_log('Utilisateur non connecté, prix HTML inchangé pour le produit ' . $product->get_id());
        return $price_html;
    }
    $user = wp_get_current_user();
    $user_roles = $user->roles;
    simproba_debug_log('Rôles utilisateur pour le produit ' . $product->get_id() . ': ' . print_r($user_roles, true));
    global $wpdb;
    $table_name = $wpdb->prefix . 'simproba_settings';
    // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
    $rules = $wpdb->get_results($wpdb->prepare("SELECT role, enable, discount_type, discount_value, categories FROM {$table_name} WHERE post_type = %s AND enable = %s", 'product', 'yes'));
    if (empty($rules)) {
        simproba_debug_log('Aucune règle active, prix HTML inchangé pour le produit ' . $product->get_id());
        return $price_html;
    }
    $product_categories = wp_get_post_terms($product->get_id(), 'product_cat', ['fields' => 'ids']);
    if (is_wp_error($product_categories)) {
        simproba_debug_log('Erreur dans wp_get_post_terms pour le produit ' . $product->get_id() . ': ' . $product_categories->get_error_message());
        return $price_html;
    }
    $product_categories = array_map('intval', $product_categories);
    simproba_debug_log('Catégories du produit ID ' . $product->get_id() . ': ' . print_r($product_categories, true));
    foreach ($user_roles as $role) {
        foreach ($rules as $rule) {
            if ($rule->role !== $role) {
                simproba_debug_log('Rôle ' . $role . ' ne correspond pas à la règle pour ' . $rule->role . ' pour le produit ' . $product->get_id());
                continue;
            }
            $rule_categories_raw = $rule->categories;
            simproba_debug_log('Catégories brutes de la règle pour le produit ' . $product->get_id() . ': ' . print_r($rule_categories_raw, true));
            $rule_categories = $rule_categories_raw ? json_decode($rule_categories_raw, true) : [];
            simproba_debug_log('Catégories décodées de la règle pour le produit ' . $product->get_id() . ': ' . print_r($rule_categories, true));
            simproba_debug_log('Type de rule_categories pour le produit ' . $product->get_id() . ': ' . gettype($rule_categories));
            if (!is_array($rule_categories)) {
                simproba_debug_log('Erreur - rule_categories n\'est pas un tableau pour le produit ' . $product->get_id() . ', règle ignorée pour le rôle ' . $role);
                continue;
            }
            $rule_categories = array_map('intval', $rule_categories);
            simproba_debug_log('Catégories converties en entiers pour le produit ' . $product->get_id() . ': ' . print_r($rule_categories, true));
            if (!empty($rule_categories)) {
                $has_matching_category = false;
                foreach ($product_categories as $cat_id) {
                    simproba_debug_log('Vérification de la catégorie produit ' . $cat_id . ' contre rule_categories pour le produit ' . $product->get_id() . ': ' . print_r($rule_categories, true));
                    if (in_array($cat_id, $rule_categories, true)) {
                        $has_matching_category = true;
                        simproba_debug_log('Catégorie correspondante trouvée: ' . $cat_id . ' pour le produit ' . $product->get_id());
                        break;
                    }
                }
                if (!$has_matching_category) {
                    simproba_debug_log('Aucune catégorie correspondante, règle ignorée pour le rôle ' . $role . ' pour le produit ' . $product->get_id());
                    continue;
                }
            } else {
                simproba_debug_log('Aucune catégorie spécifiée, remise appliquée à tous les produits pour le rôle ' . $role . ' pour le produit ' . $product->get_id());
            }
            $original_price = floatval($product->get_regular_price());
            $discount_value = floatval($rule->discount_value);
            simproba_debug_log('Application de la remise pour le rôle ' . $role . ' sur le produit ' . $product->get_id() . ': type=' . $rule->discount_type . ', valeur=' . $discount_value);
            switch ($rule->discount_type) {
                case 'percentage':
                    $new_price = $original_price * (1 - $discount_value / 100);
                    $price_html = '<del>' . wc_price($original_price) . '</del> <ins>' . wc_price($new_price) . '</ins>';
                    simproba_debug_log('Prix HTML modifié pour le produit ' . $product->get_id() . ': ' . $original_price . ' -> ' . $new_price);
                    return $price_html;
                case 'fixed':
                    $new_price = max(0, $original_price - $discount_value);
                    $price_html = '<del>' . wc_price($original_price) . '</del> <ins>' . wc_price($new_price) . '</ins>';
                    simproba_debug_log('Prix HTML modifié pour le produit ' . $product->get_id() . ': ' . $original_price . ' -> ' . $new_price);
                    return $price_html;
                case 'fixed_price':
                    $new_price = $discount_value;
                    $price_html = '<del>' . wc_price($original_price) . '</del> <ins>' . wc_price($new_price) . '</ins>';
                    simproba_debug_log('Prix HTML modifié pour le produit ' . $product->get_id() . ': ' . $original_price . ' -> ' . $new_price);
                    return $price_html;
                default:
                    simproba_debug_log('Type de remise inconnu pour le produit ' . $product->get_id() . ': ' . $rule->discount_type);
                    break;
            }
        }
    }
    simproba_debug_log('Aucune règle applicable, prix HTML inchangé pour le produit ' . $product->get_id());
    return $price_html;
}
