<?php

if (!function_exists('simproba_debug_log')) {
    function simproba_debug_log($message, ...$args) {
        if (!defined('WP_DEBUG') || !WP_DEBUG) {
            return;
        }
        $log_dir = WP_CONTENT_DIR . '/Uploads/simple-role-based-pricing';
        $log_file = $log_dir . '/simproba-debug.log';
        if (!file_exists($log_dir)) {
            if (!wp_mkdir_p($log_dir)) {
                error_log('Simple Role Based Pricing: Impossible de créer le dossier de log ' . $log_dir);
                return;
            }
            file_put_contents($log_dir . '/index.php', '<?php // Silence is golden');
            chmod($log_dir . '/index.php', 0644);
        }
        if (!file_exists($log_file)) {
            if (!file_put_contents($log_file, '')) {
                error_log('Simple Role Based Pricing: Impossible de créer le fichier de log ' . $log_file);
                return;
            }
            chmod($log_file, 0644);
        }
        if (!is_writable($log_dir)) {
            error_log('Simple Role Based Pricing: Dossier de log ' . $log_dir . ' non inscriptible');
            return;
        }
        if (!is_writable($log_file)) {
            if (!chmod($log_file, 0644)) {
                error_log('Simple Role Based Pricing: Impossible de changer les permissions du fichier ' . $log_file);
                return;
            }
        }
        $timestamp = gmdate('Y-m-d H:i:s');
        $formatted_message = vsprintf($message, $args);
        $log_message = "[$timestamp] $formatted_message\n";
        $fp = fopen($log_file, 'a');
        if ($fp) {
            flock($fp, LOCK_EX);
            fwrite($fp, $log_message);
            flock($fp, LOCK_UN);
            fclose($fp);
        } else {
            error_log('Simple Role Based Pricing: Impossible d\'ouvrir le fichier de log ' . $log_file);
        }
    }
}