<?php

defined('ABSPATH') or die('No direct access!');

class Simproba_Role_Pricing_Settings {
    private static $instance;
    private $settings;

    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        global $wpdb;
        $table_name = $wpdb->prefix . "simproba_settings";
        // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
        $results = $wpdb->get_results("SELECT * FROM {$table_name}", ARRAY_A);
        $this->settings = [];
        foreach ($results as $row) {
            $this->settings[$row['role']] = [
                'post_type' => $row['post_type'],
                'discount_type' => $row['discount_type'],
                'discount_value' => $row['discount_value'],
            ];
        }
    }

    public function get_settings() {
        return $this->settings;
    }

    public function get_setting($role) {
        return $this->settings[$role] ?? null;
    }

    public function get_active_roles() {
        return array_keys($this->settings);
    }
}
