<?php
defined('ABSPATH') or die('No direct access!');

add_action('quick_edit_custom_box', 'simproba_quick_edit_fields', 10, 2);
function simproba_quick_edit_fields($column_name, $post_type) {
    if ($post_type !== 'product' || $column_name !== 'name') return;
    $role_pricing_settings = Simproba_Role_Pricing_Settings::get_instance();
    $roles = $role_pricing_settings->get_active_roles();
    simproba_debug_log('Champs d\'édition rapide affichés pour les rôles : ' . implode(', ', $roles));
    wp_nonce_field('simproba_quick_edit_nonce', 'simproba_quick_edit_nonce');
    ?>
    <fieldset class="inline-edit-col-right">
        <div class="inline-edit-col">
            <h4><?php esc_html_e('Role Based Pricing', 'simple-role-based-pricing'); ?></h4>
            <?php foreach ($roles as $role) : ?>
                <label>
                    <span class="title"><?php echo esc_html(ucfirst($role)); ?> <?php esc_html_e('Discount Type', 'simple-role-based-pricing'); ?></span>
                    <span class="input-text-wrap">
                        <select name="simproba_discount_type_<?php echo esc_attr($role); ?>">
                            <option value=""><?php esc_html_e('None', 'simple-role-based-pricing'); ?></option>
                            <option value="percentage"><?php esc_html_e('Percentage', 'simple-role-based-pricing'); ?></option>
                            <option value="fixed"><?php esc_html_e('Fixed Amount', 'simple-role-based-pricing'); ?></option>
                        </select>
                    </span>
                </label>
                <label>
                    <span class="title"><?php echo esc_html(ucfirst($role)); ?> <?php esc_html_e('Discount Value', 'simple-role-based-pricing'); ?></span>
                    <span class="input-text-wrap">
                        <input type="number" name="simproba_discount_value_<?php echo esc_attr($role); ?>" class="text" value="" step="0.01" min="0">
                    </span>
                </label>
            <?php endforeach; ?>
        </div>
    </fieldset>
    <?php
}

add_action('save_post', 'simproba_save_quick_edit', 10, 2);
function simproba_save_quick_edit($post_id, $post) {
    if ($post->post_type !== 'product' || defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (!current_user_can('edit_posts')) {
        simproba_debug_log('Erreur : Utilisateur non autorisé à modifier le produit ' . $post_id);
        return;
    }
    if (!isset($_POST['simproba_quick_edit_nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['simproba_quick_edit_nonce'])), 'simproba_quick_edit_nonce')) {
        simproba_debug_log('Erreur : Nonce invalide pour l\'édition rapide du produit ' . $post_id);
        return;
    }

    $role_pricing_settings = Simproba_Role_Pricing_Settings::get_instance();
    $roles = $role_pricing_settings->get_active_roles();

    foreach ($roles as $role) {
        if (isset($_POST["simproba_discount_type_$role"])) {
            $discount_type = sanitize_text_field($_POST["simproba_discount_type_$role"]);
            if (in_array($discount_type, ['', 'percentage', 'fixed'], true)) {
                update_post_meta($post_id, "simproba_discount_type_$role", $discount_type);
                simproba_debug_log("Mise à jour du type de remise pour le rôle $role sur le produit $post_id : $discount_type");
            }
        }
        if (isset($_POST["simproba_discount_value_$role"])) {
            $discount_value = floatval($_POST["simproba_discount_value_$role"]);
            if ($discount_value >= 0) {
                update_post_meta($post_id, "simproba_discount_value_$role", $discount_value);
                simproba_debug_log("Mise à jour de la valeur de remise pour le rôle $role sur le produit $post_id : $discount_value");
            }
        }
    }
}
