<?php

defined('ABSPATH') or die('No direct access!');

add_action('woocommerce_product_options_pricing', 'simproba_product_fields');

function simproba_product_fields() {
    $role_pricing_settings = Simproba_Role_Pricing_Settings::get_instance();
    $roles = $role_pricing_settings->get_active_roles();
    foreach ($roles as $role) {
        woocommerce_wp_text_input([
            'id' => "simproba_price_$role",
            // translators: %s is the user role (e.g., Customer, Administrator).
            'label' => sprintf(esc_html__('Price for %s', 'simple-role-based-pricing'), esc_html(ucfirst($role))),
            'desc_tip' => true,
            'description' => esc_html__('Enter a fixed price for this role (leave empty to use discount or default price).', 'simple-role-based-pricing'),
            'value' => esc_attr(get_post_meta(get_the_ID(), "simproba_price_$role", true)),
        ]);
        woocommerce_wp_select([
            'id' => "simproba_discount_type_$role",
            // translators: %s is the user role (e.g., Customer, Administrator).
            'label' => sprintf(esc_html__('Discount Type for %s', 'simple-role-based-pricing'), esc_html(ucfirst($role))),
            'options' => [
                '' => esc_html__('None', 'simple-role-based-pricing'),
                'percentage' => esc_html__('Percentage', 'simple-role-based-pricing'),
                'fixed' => esc_html__('Fixed Amount', 'simple-role-based-pricing'),
            ],
            'value' => esc_attr(get_post_meta(get_the_ID(), "simproba_discount_type_$role", true)),
        ]);
        woocommerce_wp_text_input([
            'id' => "simproba_discount_value_$role",
            // translators: %s is the user role (e.g., Customer, Administrator).
            'label' => sprintf(esc_html__('Discount Value for %s', 'simple-role-based-pricing'), esc_html(ucfirst($role))),
            'desc_tip' => true,
            'description' => esc_html__('Enter the discount value (percentage or fixed amount).', 'simple-role-based-pricing'),
            'value' => esc_attr(get_post_meta(get_the_ID(), "simproba_discount_value_$role", true)),
        ]);
    }
}

add_action('woocommerce_process_product_meta', 'simproba_save_product_fields');

function simproba_save_product_fields($post_id) {
    $role_pricing_settings = Simproba_Role_Pricing_Settings::get_instance();
    $roles = $role_pricing_settings->get_active_roles();
    foreach ($roles as $role) {
        $price = isset($_POST["simproba_price_$role"]) ? floatval($_POST["simproba_price_$role"]) : '';
        if ($price !== '' && $price < 0) {
            $price = ''; // Ignore negative prices
        }
        update_post_meta($post_id, "simproba_price_$role", $price);
        $discount_type = isset($_POST["simproba_discount_type_$role"]) ? sanitize_text_field(wp_unslash($_POST["simproba_discount_type_$role"])) : '';
        if (!in_array($discount_type, ['', 'percentage', 'fixed'], true)) {
            $discount_type = '';
        }
        update_post_meta($post_id, "simproba_discount_type_$role", $discount_type);
        $discount_value = isset($_POST["simproba_discount_value_$role"]) ? floatval($_POST["simproba_discount_value_{$role}"]) : '';
        if ($discount_value !== '' && $discount_value < 0) {
            $discount_value = ''; // Ignore negative values
        }
        update_post_meta($post_id, "simproba_discount_value_$role", $discount_value);
    }
}
