<?php

defined('ABSPATH') or die('No direct access!');

add_filter('bulk_actions-edit-product', 'simproba_add_bulk_actions');

function simproba_add_bulk_actions($actions) {
    $role_pricing_settings = Simproba_Role_Pricing_Settings::get_instance();
    $roles = $role_pricing_settings->get_active_roles();
    foreach ($roles as $role) {
        // translators: %s is the user role (e.g., Customer, Administrator).
        $actions["set_price_$role"] = sprintf(esc_html__('Set Price for %s', 'simple-role-based-pricing'), esc_html(ucfirst($role)));
    }
    simproba_debug_log('Actions en masse ajoutées pour les rôles : ' . implode(', ', $roles));
    return $actions;
}

add_filter('handle_bulk_actions-edit-product', 'simproba_handle_bulk_action', 10, 3);

function simproba_handle_bulk_action($redirect_to, $action, $post_ids) {
    if (!current_user_can('edit_posts')) {
        simproba_debug_log('Erreur : Utilisateur non autorisé pour les actions en masse.');
        return $redirect_to;
    }
    if (!isset($_REQUEST['_wpnonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_REQUEST['_wpnonce'])), 'bulk-posts')) {
        simproba_debug_log('Erreur : Nonce invalide pour les actions en masse.');
        return $redirect_to;
    }
    $role_pricing_settings = Simproba_Role_Pricing_Settings::get_instance();
    $roles = $role_pricing_settings->get_active_roles();
    foreach ($roles as $role) {
        if ($action === "set_price_$role") {
            foreach ($post_ids as $post_id) {
                update_post_meta($post_id, "simproba_discount_type_$role", 'percentage');
                update_post_meta($post_id, "simproba_discount_value_$role", '10');
                simproba_debug_log("Mise à jour du prix pour le rôle $role sur le produit $post_id");
            }
            $redirect_to = add_query_arg("bulk_price_$role", count($post_ids), $redirect_to);
        }
    }
    return $redirect_to;
}
