<?php
 defined('ABSPATH') or die('No direct access!');
 simproba_debug_log('Étape 0: Fichier admin-settings.php chargé.');
 add_filter('woocommerce_get_settings_pages', 'simproba_add_settings_page', 30);
 function simproba_add_settings_page($settings) {
     simproba_debug_log('Étape 1: Ajout de la page de paramètres Role Based Pricing.');
     global $wpdb;
     $table_name = $wpdb->prefix . 'simproba_settings';
     $charset_collate = $wpdb->get_charset_collate();
     $sql = "CREATE TABLE %s (
         id INT(11) UNSIGNED AUTO_INCREMENT,
         role VARCHAR(50) NOT NULL,
         enable VARCHAR(3) DEFAULT 'no',
         post_type VARCHAR(20) NOT NULL DEFAULT 'product',
         discount_type ENUM('fixed', 'percentage', 'fixed_price') NOT NULL,
         discount_value DECIMAL(10,2) NOT NULL,
         categories TEXT DEFAULT NULL,
         PRIMARY KEY (id),
         UNIQUE KEY unique_role_post_type (role, post_type)
     ) $charset_collate;";
     simproba_debug_log('Étape 2: Vérification de l\'existence de la table %s.', $table_name);
     if ($wpdb->get_var($wpdb->prepare("SHOW TABLES LIKE %s", $table_name)) != $table_name) {
         require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
         simproba_debug_log('Étape 3: Table %s absente, tentative de création.', $table_name);
         dbDelta(sprintf($sql, $table_name));
         if ($wpdb->get_var($wpdb->prepare("SHOW TABLES LIKE %s", $table_name)) == $table_name) {
             simproba_debug_log('Étape 4: Table %s créée avec succès.', $table_name);
         } else {
             simproba_debug_log('Étape 5: Erreur - Échec de la création de la table %s. Erreur: ' . $wpdb->last_error, $table_name);
             return;
         }
     } else {
         simproba_debug_log('Étape 6: Table %s déjà présente.', $table_name);
     }
     class Simproba_Settings_Role_Pricing extends WC_Settings_Page {
         public function __construct() {
             $this->id = 'role_pricing';
             $this->label = esc_html__('Role Based Pricing', 'simple-role-based-pricing');
             simproba_debug_log('Étape 7: Classe Simproba_Settings_Role_Pricing instanciée.');
             parent::__construct();
         }
         public function get_settings() {
             simproba_debug_log('Étape 8: Récupération des paramètres Role Based Pricing.');
             $roles = wp_roles()->get_names();
             $categories = get_terms(['taxonomy' => 'product_cat', 'hide_empty' => false]);
             $category_options = [];
             if (is_wp_error($categories)) {
                 simproba_debug_log('Étape 9: Erreur dans get_terms: ' . $categories->get_error_message());
             } elseif (empty($categories)) {
                 simproba_debug_log('Étape 10: Aucune catégorie trouvée dans product_cat.');
             } else {
                 foreach ($categories as $category) {
                     $category_options[$category->term_id] = $category->name;
                 }
                 simproba_debug_log('Étape 11: Catégories trouvées: ' . print_r(array_keys($category_options), true));
             }
             $settings = array(
                 array(
                     'title' => esc_html__('Role Based Pricing Settings', 'simple-role-based-pricing'),
                     'type' => 'title',
                     'id' => 'simproba_settings',
                     'desc' => esc_html__('Configure global pricing rules for user roles.', 'simple-role-based-pricing'),
                 ),
                 array(
                     'title' => esc_html__('Select Role', 'simple-role-based-pricing'),
                     'id' => 'simproba_role_selector',
                     'type' => 'select',
                     'options' => array_combine(array_keys($roles), array_map(function($name) { return esc_html($name); }, $roles)),
                     'desc' => esc_html__('Select a role to configure its pricing settings.', 'simple-role-based-pricing'),
                     'css' => 'min-width: 200px;',
                 ),
                 array(
                     'title' => esc_html__('Apply To', 'simple-role-based-pricing'),
                     'id' => 'simproba_apply_to',
                     'type' => 'select',
                     'options' => [
                         'all' => __('All Products', 'simple-role-based-pricing'),
                         'categories' => __('Specific Categories (Pro version)', 'simple-role-based-pricing'),
                     ],
                     'desc' => esc_html__('Choose whether to apply pricing to all products or specific categories (Pro version required for categories).', 'simple-role-based-pricing'),
                     'css' => 'min-width: 200px;',
                 ),
                 array(
                     'type' => 'sectionend',
                     'id' => 'simproba_settings',
                 ),
             );
             simproba_debug_log('Étape 12: Paramètres générés avec ' . count($category_options) . ' catégories.');
             return apply_filters('woocommerce_get_settings_' . $this->id, $settings);
         }
         public function output() {
             simproba_debug_log('Étape 13: Début de output() pour Role Based Pricing.');
             global $wpdb;
             $table_name = $wpdb->prefix . 'simproba_settings';
             simproba_debug_log('Étape 14: Chargement des données depuis %s.', $table_name);
             $db_settings = $wpdb->get_results("SELECT role, enable, discount_type, discount_value, categories FROM $table_name WHERE post_type = 'product'");
             simproba_debug_log('Étape 15: Résultat brut de la requête SQL: ' . print_r($db_settings, true));
             if ($wpdb->last_error) {
                 simproba_debug_log('Étape 16: Erreur lors du chargement des données: ' . $wpdb->last_error);
             }
             $db_settings_map = [];
             foreach ($db_settings as $setting) {
                 $db_settings_map[$setting->role] = [
                     'enable' => $setting->enable ?: 'no',
                     'discount_type' => $setting->discount_type ?: 'percentage',
                     'discount_value' => floatval($setting->discount_value) ?: 0,
                     'apply_to' => !empty($setting->categories) ? 'categories' : 'all',
                     'categories' => $setting->categories ? json_decode($setting->categories, true) : []
                 ];
                 simproba_debug_log('Étape 17: Mapping pour le rôle ' . $setting->role . ': ' . print_r($db_settings_map[$setting->role], true));
             }
             simproba_debug_log('Étape 18: Settings map complet: ' . print_r($db_settings_map, true));
             $roles = wp_roles()->get_names();
             parent::output();
             $categories = get_terms(['taxonomy' => 'product_cat', 'hide_empty' => false]);
             $category_options = [];
             if (is_wp_error($categories)) {
                 simproba_debug_log('Étape 19: Erreur dans get_terms: ' . $categories->get_error_message());
             } elseif (empty($categories)) {
                 simproba_debug_log('Étape 20: Aucune catégorie trouvée dans product_cat.');
             } else {
                 foreach ($categories as $category) {
                     $category_options[$category->term_id] = $category->name;
                 }
                 simproba_debug_log('Étape 21: Catégories trouvées: ' . print_r(array_keys($category_options), true));
             }
             ?>
             <div id="simproba_category_selector_container" style="display: none; margin-top: 20px;">
                 <div class="field-list" id="available-categories">
                     <h3><?php esc_html_e('Available Categories', 'simple-role-based-pricing'); ?></h3>
                     <ul>
                         <?php if (empty($category_options)) : ?>
                             <li><?php esc_html_e('No categories available. Please create some in WooCommerce.', 'simple-role-based-pricing'); ?></li>
                         <?php else : ?>
                             <?php foreach ($category_options as $id => $name) : ?>
                                 <li data-category="<?php echo esc_attr($id); ?>"><?php echo esc_html($name); ?></li>
                             <?php endforeach; ?>
                         <?php endif; ?>
                     </ul>
                 </div>
                 <div class="arrows">
                     <button class="arrow-btn" data-direction="right">→</button>
                     <button class="arrow-btn" data-direction="left">←</button>
                 </div>
                 <div class="field-list" id="selected-categories">
                     <h3><?php esc_html_e('Selected Categories', 'simple-role-based-pricing'); ?></h3>
                     <ul></ul>
                 </div>
             </div>
             <div id="simproba_role_fields_container" style="margin-top: 20px;"></div>
             <?php
             foreach ($roles as $role => $name) :
                 $enable_value = isset($db_settings_map[$role]['enable']) ? $db_settings_map[$role]['enable'] : 'no';
                 $discount_type_value = isset($db_settings_map[$role]['discount_type']) ? $db_settings_map[$role]['discount_type'] : 'percentage';
                 $discount_value = isset($db_settings_map[$role]['discount_value']) ? $db_settings_map[$role]['discount_value'] : 0;
                 $apply_to_value = isset($db_settings_map[$role]['apply_to']) ? $db_settings_map[$role]['apply_to'] : 'all';
                 $categories_value = isset($db_settings_map[$role]['categories']) ? json_encode($db_settings_map[$role]['categories']) : '[]';
                 simproba_debug_log('Étape 22: Champ caché pour rôle ' . $role . ': enable=' . $enable_value . ', discount_type=' . $discount_type_value . ', discount_value=' . $discount_value . ', apply_to=' . $apply_to_value . ', categories=' . $categories_value);
             ?>
                 <input type="hidden" name="simproba_enable_<?php echo esc_attr($role); ?>" value="<?php echo esc_attr($enable_value); ?>">
                 <input type="hidden" name="simproba_discount_type_<?php echo esc_attr($role); ?>" value="<?php echo esc_attr($discount_type_value); ?>">
                 <input type="hidden" name="simproba_discount_value_<?php echo esc_attr($role); ?>" value="<?php echo esc_attr($discount_value); ?>">
                 <input type="hidden" name="simproba_apply_to_<?php echo esc_attr($role); ?>" value="<?php echo esc_attr($apply_to_value); ?>">
                 <input type="hidden" name="simproba_categories_<?php echo esc_attr($role); ?>" value="<?php echo esc_attr($categories_value); ?>">
             <?php endforeach; ?>
             <?php wp_nonce_field('simproba_settings_nonce', 'simproba_settings_nonce'); ?>
             <?php
             simproba_debug_log('Étape 23: Rendu des sections category_selector et role_fields dans output. Champs cachés générés pour tous les rôles.');
             simproba_debug_log('Étape 24: Fin de output() pour Role Based Pricing.');
         }
         public function save() {
             simproba_debug_log('Étape 25: Début de la sauvegarde des paramètres Role Based Pricing (POST).');
             simproba_debug_log('Étape 26: POST data reçus: ' . print_r($_POST, true));
             if (!isset($_POST['simproba_settings_nonce'])) {
                 simproba_debug_log('Étape 27: Erreur - Nonce absent (POST). Arrêt de la sauvegarde.');
                 return;
             }
             simproba_debug_log('Étape 28: Nonce présent dans POST.');
             $nonce = sanitize_text_field(wp_unslash($_POST['simproba_settings_nonce']));
             simproba_debug_log('Étape 29: Nonce reçu: ' . $nonce);
             if (!wp_verify_nonce($nonce, 'simproba_settings_nonce')) {
                 simproba_debug_log('Étape 30: Erreur - Nonce invalide (POST). Arrêt de la sauvegarde.');
                 return;
             }
             simproba_debug_log('Étape 31: Nonce vérifié avec succès.');
             if (!current_user_can('manage_woocommerce')) {
                 simproba_debug_log('Étape 32: Erreur - Utilisateur non autorisé à gérer les paramètres WooCommerce (POST). Arrêt de la sauvegarde.');
                 return;
             }
             simproba_debug_log('Étape 33: Permissions utilisateur vérifiées.');
             global $wpdb;
             $table_name = $wpdb->prefix . 'simproba_settings';
             simproba_debug_log('Étape 34: Tableau cible: ' . $table_name);
             $roles = wp_roles()->get_names();
             simproba_debug_log('Étape 35: Rôles disponibles: ' . print_r($roles, true));
             simproba_debug_log('Étape 36: Tentative de suppression des anciennes données pour post_type=product.');
             $delete_result = $wpdb->delete($table_name, array('post_type' => 'product'));
             if ($delete_result === false) {
                 simproba_debug_log('Étape 37: Erreur - Échec de la suppression des anciennes données. Erreur: ' . $wpdb->last_error);
                 return;
             }
             simproba_debug_log('Étape 38: Suppression des anciennes données réussie.');
             foreach ($roles as $role => $name) {
                 simproba_debug_log('Étape 39: Traitement du rôle: ' . $role);
                 $enable = isset($_POST["simproba_enable_${role}"]) ? sanitize_text_field(wp_unslash($_POST["simproba_enable_${role}"])) : 'no';
                 simproba_debug_log('Étape 40: Rôle ' . $role . ' - Enable: ' . $enable);
                 if ($enable === 'yes') {
                     $discount_type = isset($_POST["simproba_discount_type_{$role}"]) ? sanitize_text_field(wp_unslash($_POST["simproba_discount_type_{$role}"])) : 'percentage';
                     $discount_value = isset($_POST["simproba_discount_value_{$role}"]) ? floatval($_POST["simproba_discount_value_{$role}"]) : 0;
                     $apply_to = isset($_POST["simproba_apply_to_{$role}"]) ? sanitize_text_field(wp_unslash($_POST["simproba_apply_to_{$role}"])) : 'all';
                     $categories_raw = isset($_POST["simproba_categories_{$role}"]) ? sanitize_text_field(wp_unslash($_POST["simproba_categories_{$role}"])) : '';
                     $categories = !empty($categories_raw) ? json_decode(sanitize_text_field($categories_raw), true) : [];
                     simproba_debug_log('Étape 41: Rôle ' . $role . ' - Champs reçus: enable=' . $enable . ', type=' . $discount_type . ', valeur=' . $discount_value . ', apply_to=' . $apply_to . ', categories=' . json_encode($categories));
                     if (!is_array($categories)) {
                         simproba_debug_log('Étape 42: Erreur - Categories invalides pour le rôle ' . $role . '. Valeur reçue: ' . ($categories_raw ?? 'aucune'));
                         $categories = [];
                     }
                     $categories = array_map('intval', $categories);
                     if (!in_array($discount_type, ['fixed', 'percentage', 'fixed_price'], true)) {
                         simproba_debug_log('Étape 43: Erreur - Type de remise invalide pour le rôle ' . $role . ': ' . $discount_type);
                         continue;
                     }
                     if ($discount_value < 0) {
                         simproba_debug_log('Étape 44: Erreur - Valeur de remise négative pour le rôle ' . $role . ': ' . $discount_value);
                         continue;
                     }
                     simproba_debug_log('Étape 45: Sauvegarde pour le rôle ' . $role . ': enable=' . $enable . ', type=' . $discount_type . ', valeur=' . $discount_value . ', apply_to=' . $apply_to . ', categories=' . json_encode($categories));
                     $insert_result = $wpdb->insert(
                         $table_name,
                         array(
                             'role' => $role,
                             'enable' => $enable,
                             'post_type' => 'product',
                             'discount_type' => $discount_type,
                             'discount_value' => $discount_value,
                             'categories' => $apply_to === 'categories' ? json_encode($categories) : null,
                         ),
                         array('%s', '%s', '%s', '%s', '%f', '%s')
                     );
                     if ($insert_result === false) {
                         simproba_debug_log('Étape 46: Erreur - Échec de l\'insertion pour le rôle ' . $role . '. Erreur: ' . $wpdb->last_error);
                         return;
                     }
                     simproba_debug_log('Étape 47: Insertion réussie pour le rôle ' . $role . '.');
                 } else {
                     simproba_debug_log('Étape 48: Rôle ' . $role . ' non activé (enable=' . $enable . ').');
                 }
             }
             simproba_debug_log('Étape 49: Appel de parent::save().');
             parent::save();
             simproba_debug_log('Étape 50: Fin de la sauvegarde des paramètres Role Based Pricing (POST).');
         }
     }
     simproba_debug_log('Étape 51: Création de l\'instance Simproba_Settings_Role_Pricing.');
     $settings[] = new Simproba_Settings_Role_Pricing();
     simproba_debug_log('Étape 52: Page Role Based Pricing ajoutée au tableau des paramètres.');
     return $settings;
 }
